---
title: Lecture 38：常系数非齐次线性微分方程
tags:
  - 数学
  - 微分方程
categories: 
date: 2024-02-02
---
---
## 1.1 非齐次微分方程
### 1.1.1 基本概念
##### **定义**： #常系数非齐次线性微分方程
> <font color="#ccc1d9">描述：</font>
> 1. 形式：$$y^{\prime\prime}+py^{\prime}+qy=f(x)$$
> 2. 两种非齐次项：
> 	1. $$f(x)=e^{\lambda x}P_m(x)$$
> 	2. $$f (x)=e^{\alpha x}\left\lfloor P_{l}^{(1)}(x)\cos\beta x+P_{n}^{(2)}(x)\sin\beta x\right\rfloor$$

**解释**
+ 概念：
	+ 和常系数齐次线性微分方程相比，其多了非齐次项 $f(x)$：$y^{\prime\prime}+py^{\prime}+qy=f(x)$
+ 解决思路：
	+ 将不齐次的方程，转化为两个部分：
	+ 非齐次通解 = 齐次的通解 + 非齐次的特解；
+ 三种待定特解：
	+ 情况 1：若非齐次项是 $f(x)=e^{\lambda x}P_{m}(x)$
		+ 待定特解为：$y^{*}=x^{k}Q_{m}(x)e^{\lambda x}$
	+ 情况 2：若非齐次项是 $f(x)=e^{\alpha}[P_l(x)\cos\beta x+Q_n(x)\sin\beta x]$
		+ 即非齐次项是 $指数×多项式×三角$；
		+ $y^{*}=x^{k}e^{\alpha x}\bigl[R_{m}^{(1)}(x)\cos\beta x+R_{m}^{(2)}(x)\sin\beta x\bigr].\quad m=\max\{l,n\}$
	+ 情况 3：若非齐次项既有情况 1、也有情况 2
		+ 分别计算情况 1 和情况 2 的待定特解，然后将它们两个待定特解**相加得到待定特解**；

**总结**：方法
+ 1. 确定解由几个成分构成，如果由多个成分构成，需要分别为其设特解；
+ 2. 求出齐次通解
	+ 第一步：写特征方程
	+ 第二步：找出特征根
	+ 第三步，根据根的方程，写出对应式子
		+ 注意：
			+ 齐次通解中的 $e$ 是 $e^{r x}$，而不是 $e^{\lambda x}$ 
			+ 所以可以由齐次方程的通解式，知道当前非齐次方程的特征方程 $r$，但注意是 $r$、不是齐次式中的 $\lambda$
		+ 若是单实根
			+ 通解：$y=C_1e^{r_1x}$
		+ 若是不等实根 
			+ 通解： $y=C_1e^{r_1x}+C_2e^{r_2x}$
		+ 若是相等实根 
			+ 通解：$y=e^{rx}(C_1+C_2x)$
		+ 若是共轭复根：$r_{1,2}=\alpha\pm i\beta$
			+ $\beta$ 为求出来的特征根后背的系数，即此式子 $r_{1,2}=\alpha\pm i\beta$ 中的 $\beta$
			+ 通解：$y=e^{\alpha x}(C_1\cos\beta x+C_2\sin\beta x)$
+ 3. 设特解 $y^{*}$： 
	+ 为每个部分设出待定特解为：$y^{*}=x^{k}Q_{m}(x)e^{\lambda x}$ 或者 $y^{*}=x^{k}e^{\alpha x}\bigl[R_{m}^{(1)}(x)\cos\beta x+R_{m}^{(2)}(x)\sin\beta x\bigr]$
+ 4. 求待定特解各项： 
	+ $e^{\lambda x}$ 或 $e^{\alpha x}$
		+ `->` 直接从原式中带进来 `->` 顺便还定了这个 $\lambda$ 或者 $\alpha$ 的值；
	+ $Q_m(x)$ 
		+ 根据 $P(x)$ 的情况，分析：
		+ 如果 $P(x)$ 是情况一：$P_{m}(x)$
			+ 观察原式的 $P_{m}(x)$
			+ 如果是常数项，设为 $a$；
			+ 如果是一次项，设为 $ax+b$；
			+ 如果是二次式，设为 $ax^2+bx+c$；
		+ 如果 $P(x)$ 是情况二：$\bigl[R_{m}^{(1)}(x)\cos\beta x+R_{m}^{(2)}(x)\sin\beta x\bigr]$
			+ 如果 cos 和 sin 都存在：
				+ 取原式中 $P_{l}^{(1)}(x)$ 和 $P_{n}^{(2)}(x)$ 当中的最高项；
					+ 原式为 $f (x)=e^{\alpha x}\left\lfloor P_{l}^{(1)}(x)\cos\beta x+P_{n}^{(2)}(x)\sin\beta x\right\rfloor$
				+ 如果是常数项，设为 $A\sin x+B\cos x$；
				+ 如果是一次项，设为 $(Ax+B)\sin x+(Cx+D)\cos x$  类似这种形式；
			+ 如果 cos 和 sin 只有一个存在：
				+ 其存在的那个函数当中的值作为最高项，步骤同 cos 和 sin 都存在时；
	+ $x^{k}$ 
		+ 确定 $x^{k}$ 的 $k$：
		+ 如果是情况一：
			+ 如何确定几重根 `->` k 的数值，是当前方程的**齐次方程中求出来的特征方程中、含根 $\lambda$ 的次数**。
			+ 举例：求齐次方程的通解后，得到 $r_1=3,r_2=1$ ，若 $\lambda =2$，则特征方程中出现了 0 次根 $\lambda$  `->` 所以 $k=0$
		+ 如果是情况二：
			+ 根据 $\alpha+i\beta$ 是方程的几重根，判断 $k$ 的取值
				+ $\alpha$ 来自 $e^{\alpha x}$ 中，$\beta$ 来自 $P_{l}^{(1)}(x)\cos\beta x+P_{n}^{(2)}(x)\sin\beta x$ 的三角函数中；
			+ 如果是单根，这个 $x^{k}$ 里面的 $k$ 就是 $1$ 次方，如果是双根，这个里面的 $k$ 就是 $2$ 次方；
			+ 注意： 
				+ 如果 $r_{1,2}=\pm 1$，此时表示是一个特征根，因为两个特征根一样；
				+ 所以如果解出 $\alpha+i\beta=\pm 1$ ，则此时表示的是一重根，而不是两重根；
+ 5. 确定系数与任意常数
	+ （1）确定非齐次项待定特解的系数
		+ 在前面设好了 $y^{*}$ 的各个成分后，因为此时 $y^{*}$ 当中还有待定系数，此时将设好的函数代换原方程，比较两端同次幂的系数，然后得到 $y^{*}$ 的结果；
		+ 假如当前方程式是 $y^{\prime\prime}+y=\sin x$，此时就需要将 $y({*})$ 和 $y^{\prime\prime}(*)$ 代入原方程中，然后比较两端同次幂的系数，然后得到 $y^{*}$ 中各个系数的结果；
	+ （2）确定齐次项通解的任意常数 $C_1$ 和 $C_2$
		+ 在原方程式中，找出两个方程的特解，比如求出 $f(0)=0$、$f^{\prime}{0}=1$；
		+ 将其代入齐次方程的通解式中、解出任意常数；
		+ 注意：非齐次的特解在定出系数后，也需要带入到齐次方程的通解式当中，帮助定出任意常数；
+ 6. 若是三阶及其以上的微分方程，按照以下方法合并
	+ ![[Pasted image 20240815124753.png]]
+ 7. 如果需要求出整个方程的特解，则可以将限制条件代入到通解式当中，定出其中的常数 $C_1$，$C_2$，得到微分方程的特解；
+ 补充：
	+ 1. 非齐次项部分两个解的差，等于齐次的一个解；
	+ 2. 非齐次项的解具有叠加性；

### 1.1.2 方法总结
**解题方法**
+ 核心思想：
	+ 因为非齐次方程通解 = 齐次的通解 + 非齐次的特解；所以需要先使用 Lecture 38 中学习的常系数齐次微分方程当中的设特征方程的方法，求出齐次的通解。然后再使用本小节 Lecture 39 当中学习的求待定特解的方法，求出非齐次特解，然后把它们两相加，得到非齐次通解；
+ 具体步骤： 
	+ 第一步：设出当前微分方程的特征方程，求出 **(1)齐次的通解**
	+ 第二步：根据非齐次项类型，设处正确的待定特解 $y^*$
	+ 第三步：将待定特解带入原方程当中
	+ 第四步：解出 **(2)非齐次待定特解**
	+ 第五步：求出 **(3)非齐次通解**：非齐次通解 = 齐次的通解 + 非齐次的特解
